<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 17.12.13 11:54
 */

namespace VM\ApiBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\DependencyInjection\ContainerInterface;
use VM\AdminBundle\Services\ApiCreator;
use VM\AdminBundle\Services\ApiGetter;
use VM\AdminBundle\Services\AuthCommunication;
use VM\AdminBundle\Services\SsoCommunication;
use VM\ApiBundle\Entity\User;
use VM\ApiBundle\Entity\UserPageSpentTime;

abstract class AbstractController extends Controller
{
    public function setContainer(ContainerInterface $container = null)
    {
        parent::setContainer($container);
        $this->containerInitialized();
    }

    /**
     * Perform some operations after controller initialized and container set.
     */
    private function containerInitialized()
    {
        if($this->getUser() instanceof User)
        {
            if(!$this->getRequest()->getSession()->has('time_spent_id'))
            {
                $this->createUserPageSpentTime();
            }
            else
            {
                $UserPageSpentTime = $this->getUserPageSpentTime($this->getRequest()->getSession()->get('time_spent_id'));
                if(empty($UserPageSpentTime))
                {
                    $this->createUserPageSpentTime();
                }
                else
                {
                    $this->updateUserPageSpentTime($UserPageSpentTime);
                }
            }


            if($this->getRequest()->getSession()->has('user_sso_token'))
            {
                $SsoCommunication = $this->get('vm_admin.sso.communication');
                try
                {
                    $response = $SsoCommunication->checkUserToken($this->getUser()->getExternalId(), $this->getRequest()->getSession()->get('user_sso_token'));
                    if(empty($response['token_valid']))
                    {
                        $this->getRequest()->getSession()->invalidate();
                        $this->get("security.context")->setToken(null);
                    }
                }
                catch(\Exception $Exception)
                {
                    $this->getRequest()->getSession()->invalidate();
                    $this->get("security.context")->setToken(null);
                }
            }
        }
    }


    /**
     * @param $id
     * @return UserPageSpentTime
     */
    private function getUserPageSpentTime($id)
    {
        return $this->getDoctrine()->getRepository('VMApiBundle:UserPageSpentTime')->find($id);
    }


    /**
     * @return UserPageSpentTime
     */
    private function createUserPageSpentTime()
    {
        $UserPageSpentTime = new UserPageSpentTime();
        $UserPageSpentTime->setUser($this->getUser());
        $this->getDoctrine()->getManager()->persist($UserPageSpentTime);
        $this->getDoctrine()->getManager()->flush();

        $this->getRequest()->getSession()->set('time_spent_id', $UserPageSpentTime->getId());

        return $UserPageSpentTime;
    }


    /**
     * @param UserPageSpentTime $UserPageSpentTime
     */
    private function updateUserPageSpentTime(UserPageSpentTime $UserPageSpentTime)
    {
        $UserPageSpentTime->setEndAt(new \DateTime());
        $this->getDoctrine()->getManager()->flush();
    }



    /**
     * @return ApiGetter
     */
    protected function getApiGetter()
    {
        return $this->get('vm_admin.api.getter');
    }


    /**
     * @return ApiCreator
     */
    protected function getApiCreator()
    {
        return $this->get('vm_admin.api.creator');
    }

    /**
     * @return SsoCommunication
     */
    protected function getSsoCommunication()
    {
        return $this->get('vm_admin.sso.communication');
    }

    /**
     * @return AuthCommunication
     */
    protected function getAuthCommunication()
    {
        return $this->get('vm_admin.auth.communication');
    }
}